#include "stdafx.h"
#include "Serial.h"
#include <stdio.h>

HANDLE  RadioHandle;

BOOL RFID_RadioOpen(HANDLE *pHandle, UINT32 port, ULONG baudRate, UINT32 flags)
{
	DCB dcb = {0};
	char comPort[32];
	COMMTIMEOUTS timeouts = {0};
	
	sprintf(comPort, SER_COM_FMT, port);
	if (NULL == pHandle)
	{
		return FALSE;
	}
	*pHandle = CreateFile(comPort,
		GENERIC_READ|GENERIC_WRITE,		//access ( read and write)
		0,								//(share) 0:cannot share the COM port                        
		0,								// security  (None)                
		OPEN_EXISTING,					// creation : open_existing
		FILE_ATTRIBUTE_NORMAL,			// NO overlapped operation
		0								// no templates file for COM port...
		);
	if (*pHandle == INVALID_HANDLE_VALUE)
	{
		return FALSE;
	}

	/* Set handle */
	RadioHandle   = *pHandle;
	dcb.DCBlength = sizeof(DCB);
	if (!GetCommState(*pHandle, &dcb))
	{
		return FALSE;
	}
	
	dcb.BaudRate    = baudRate;
	dcb.ByteSize    = SER_COM_BYTESIZE;
	dcb.Parity      = SER_COM_PARITY;	
	dcb.StopBits    = SER_COM_STOPBIT;
	if (!SetCommState(*pHandle, &dcb))
	{
		return FALSE;
	}
	
	// The maximum time allowed to elapse between the arrival of two bytes
	// on the communications line, in milliseconds. During a ReadFile 
	// operation, the time period begins when the first byte is received. 
	// If the interval between the arrival of any two bytes exceeds this 
	// amount, the ReadFile operation is completed and any buffered data 
	// is returned. A value of zero indicates that interval time-outs are 
	// not used. 
	timeouts.ReadIntervalTimeout = 100;
	
	// The multiplier used to calculate the total time-out period for read
	// operations, in milliseconds. For each read operation, this value is 
	// multiplied by the requested number of bytes to be read.
	timeouts.ReadTotalTimeoutMultiplier = 10;	
	
	// A constant used to calculate the total time-out period for read 
	// operations, in milliseconds. For each read operation, this value is 
	// added to the product of the ReadTotalTimeoutMultiplier member and 
	// the requested number of bytes. 
	timeouts.ReadTotalTimeoutConstant = READ_TOTAL_TIMEOUT_CONSTANT;	
	
	// total_bytes * ReadTotalTimeoutMultiplier + ReadTotalTimeoutConstant = max delay
	// same as above but for writes
	timeouts.WriteTotalTimeoutConstant   = 10;
	timeouts.WriteTotalTimeoutMultiplier = 10;
	if (!SetCommTimeouts(*pHandle, &timeouts))
	{
		return FALSE;
	}

	return TRUE;
}

BOOL RFID_RadioClose(HANDLE handle)
{
	if (!CloseHandle(handle))
	{
		return FALSE;
	}
	return TRUE;
}

UINT32 RFID_RadioWrite(HANDLE pRadio, UINT8 *data, UINT32 nbytes)
{
	DWORD dwRetVal;
	DWORD dwWritten;
	dwRetVal = WriteFile(pRadio, data, nbytes, &dwWritten, NULL);
	return dwRetVal;
}

UINT32 RFID_RadioRead(HANDLE pRadio, UINT8 *data, UINT32 nbytes, UINT32 msTimeout)
{
	DWORD dwBytesRead;	
	DWORD dwRetVal;
	COMMTIMEOUTS timeouts = {0};
	
	if (!GetCommTimeouts(pRadio, &timeouts))
	{
		return FALSE;
	}
	timeouts.ReadIntervalTimeout = msTimeout;
	if (!SetCommTimeouts(pRadio, &timeouts))
	{
		return FALSE;
	}

	dwRetVal = ReadFile(pRadio, data, nbytes, &dwBytesRead, NULL);
	return dwBytesRead;
}